import grpc
import calculator_pb2
import calculator_pb2_grpc


def main():
    # Create a channel to the server
    channel = grpc.insecure_channel('localhost:50051')
    
    # Create a stub (client)
    stub = calculator_pb2_grpc.CalculatorStub(channel)
    
    print("gRPC Calculator Client")
    print("=" * 40)
    
    # Call remote methods
    # Note: we must create message objects, not pass raw values
    result = stub.Add(calculator_pb2.BinaryOperation(a=5, b=3))
    print(f"Add(5, 3) = {result.value}")
    
    result = stub.Subtract(calculator_pb2.BinaryOperation(a=10, b=4))
    print(f"Subtract(10, 4) = {result.value}")
    
    result = stub.Multiply(calculator_pb2.BinaryOperation(a=7, b=6))
    print(f"Multiply(7, 6) = {result.value}")
    
    result = stub.Divide(calculator_pb2.BinaryOperation(a=15, b=3))
    print(f"Divide(15, 3) = {result.value}")
    
    # Error handling
    print("\nTesting error handling:")
    try:
        result = stub.Divide(calculator_pb2.BinaryOperation(a=10, b=0))
        print(f"Divide(10, 0) = {result.value}")
    except grpc.RpcError as e:
        print(f"Error: {e.code()}: {e.details()}")
    
    channel.close()


if __name__ == '__main__':
    main()

